#version 330
#extension GL_EXT_gpu_shader4 : enable
// Floating Green CirclesMod01.fsh  by  LoganLang

//https://www.shadertoy.com/view/7dKXDD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const vec3 keyLime = vec3(236., 243., 158.)/255.;
const vec3 olivine = vec3(144., 169., 85.)/255.;
const vec3 sapGreen = vec3(79., 119., 45.)/255.;
const vec3 hunterGreen = vec3(49., 87., 44.)/255.;

float sdCircle(vec2 st, float r){ 
return length(st) - r; 
} 

float stroke(float x, float w, float s){ 
    w *= .5; 
    return 1.-smoothstep(w-s,w+s,abs(x)); 
} 

float fill(float sdf,float s){
    return 1.-smoothstep(-s,s,sdf);
}

vec3 draw(vec3 col, vec3 addCol, vec2 uv, float mult){
    uv *= mult;
    uv.x += iTime;
    uv.y += (iTime*.01*mult) * step(1.,mod(uv.x,2.));
    uv.y -= (iTime*.01*mult) * (1.-step(1.,mod(uv.x,2.)));
    uv = fract(uv);
    col = mix(col,vec3(.05),fill(sdCircle(uv-.5,.2),.04));
    col = mix(col,addCol,stroke(sdCircle(uv-.5,.15),.1,.0015*mult));
    return col;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 col = hunterGreen;
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    uv.x *= iResolution.x/iResolution.y;

    col = draw(col, keyLime, uv, 10.);
    col = draw(col, olivine, uv, 5.5);
    col = draw(col, sapGreen, uv, 3.5);

    gl_FragColor = vec4(col,1.0);
}